﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using GE.Visualisation;
using GE.Physics.Shapes;
using GE.Physics;
using System.Collections.Generic;
using Microsoft.Xna.Framework;

namespace GE.World.Entities
{
    class ExplosionEntity:WorldEntity
    {
        /// <summary>
        /// Animation's id
        /// </summary>
        int _iIdAnimation;

        /// <summary>
        /// Current frame displayed
        /// </summary>
        int _iCurrentAnimationFrame;

        /// <summary>
        /// Current animation time;
        /// </summary>
        int _iCurrentAnimationTime;

        /// <summary>
        /// Flag set when the animation is over
        /// </summary>
        bool _bAnimationOver;

        /// <summary>
        /// Constructor
        /// </summary>
        public ExplosionEntity()
            : base()
        {
            _iIdAnimation = -1;
            _iCurrentAnimationFrame = -1;
            _iCurrentAnimationTime = -1;
            _bAnimationOver = false;
        }

        /// <summary>
        /// Activator
        /// </summary>
        /// <param name="idAnimation"></param>
        public void activate(int idAnimation, Vector2 position)
        {
            _v2Position = position;
            _iIdAnimation = idAnimation;
            _iCurrentAnimationFrame = -1;
            _iCurrentAnimationTime = -1;
            _bAnimationOver = false;
            base.activate();
        }

        /// <summary>
        /// Update
        /// </summary>
        public override void update()
        {
            if (_bAnimationOver)
                die();
        }

        /// <summary>
        /// Render
        /// </summary>
        public override void render()
        {
            _bAnimationOver = Visu.Instance.displayAnimation(_iIdAnimation, ScreenPosition, ref _iCurrentAnimationFrame, ref _iCurrentAnimationTime);
        }

        /// <summary>
        /// Die
        /// </summary>
        public override void die()
        {
            _bActive = false;
        }
    }
}
